package com.izenpe.zain.cliente.xades;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyResponse;

public class ActualizacionFirmaXML {
	// Nombre del fichero a ser actualizado mediante la firma XML.
	private static final String fileName = "DemoSignedEnvelopingTS.xml";

	public static void main(String[] args) {
		try {
			// Asignacin de la configuracin de forma programtica
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);

			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 * 
			 * SmartVerifyRequest.Service.DR para que la peticin de
			 * verificacin de firma tambin sea una peticin de actualizacin
			 * de firma (dirigida al servicio DR de TrustedX).
			 * 
			 * El valor por defecto de este parmetro es
			 * SmartVerifyRequest.Service.DSV para solicitar slo una
			 * verificacin de firma al servicio DSV.
			 */
			SmartVerifyRequest smartVerifyReq = new SmartVerifyRequest(Propiedades.ZAIN_ENDPOINT,
					SmartVerifyRequest.Service.DR);

			// Se establece el perfil No Repudio en la peticin de Verificacin
			// de firma.
			smartVerifyReq.setProfile(Constants.Profile.NONREP);

			/*
			 * Se establece el idioma de la peticin en espaol. 2
			 * posibilidades: 1. Espaol: 'es' 2. Ingls: 'en'
			 */
			smartVerifyReq.setLanguage("es");

			/*
			 * Se solicita en la peticin de Verificacin que se aadan a la
			 * respuesta los valores de los certificados.
			 */
			smartVerifyReq.setAddCertificateValues(Constants.AddValues.BINARY);

			/*
			 * Se solicita en la peticin de Verificacin que se aadan a la
			 * respuesta la informacin de revocacin de los certificados.
			 */
			smartVerifyReq.setAddRevocationValues(Constants.AddValues.BINARY);

			/*
			 * Se solicita en la peticin de Verificacin que se aadan los
			 * valores del Sello de Tiempo.
			 */
			smartVerifyReq.setAddTimeStampValues(Constants.AddValues.BINARY);

			/*
			 * True para que la respuesta incluya el formato de la firma (e.g.
			 * BES, ES-T). La invocacin de mtodo es indispensable para
			 * consultar el formato de la respuesta con getSignatureForm.
			 */
			smartVerifyReq.setAddSignatureForm(true);

			/*
			 * Constants.SignatureFormat.ES_T para solicitar un sello de tiempo
			 * en la firma. Con el valor Constants.SignatureFormat.ES_A, la
			 * respuesta aadira informacin sobre la validez del certificado.
			 */
			smartVerifyReq.setReturnUpdatedSignature(Constants.SignatureFormat.ES_A);

			// Datos a verificar.
			smartVerifyReq.setInputXmlBase64(Base64.encode(ZainUtil.readBinaryFile("data/output/" + fileName)));

			// Envo de la peticin.
			SmartVerifyResponse smartVerifyResp = smartVerifyReq.send();

			/*
			 * 0 para consultar la primera y nica firma. Sin una invocacin
			 * previa de setAddSignatureForm(true), este mtodo devuelve null.
			 */
			System.out.println("Verificando firma con formato: " + smartVerifyResp.getSignature(0).getSignatureForm());

			// Se comprueba la validez de la respuesta de Actualizacin de firma
			// XML.
			if (Constantes.RMAJOR_SUCCESS.equals((smartVerifyResp.getResultMajor()))
					&& Constantes.RMINOR_SUCCESS.equals(smartVerifyResp.getResultMinor())) {
				String signXML = smartVerifyResp.getDocumentWithSignatureXml();
				String destFilename = "data/output/" + fileName.substring(0, fileName.lastIndexOf(".")) + "Archive.xml";
				ZainUtil.writeBinaryFile(destFilename, signXML.getBytes());
				System.out.println("La firma ha sido actualizada con xito.");
			} else {
				System.out.println("La actualizacin de la firma contiene errores: "
						+ smartVerifyResp.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}